/*
* Includes
*/
#include <stdlib.h>
#include <stdio.h>
#include <avr/io.h>
#include <avr/interrupt.h>
#include "adelay.h"
#include "lcd.h"
//Define the ports for the LCD :)
#define LCD_D4_BIT PD0
#define LCD_D5_BIT PD1
#define LCD_D6_BIT PD2
#define LCD_D7_BIT PD3

#define LCD_RW_BIT PD4
#define LCD_RS_BIT PD5
#define LCD_E_BIT PD6

#define OUTPUT_PORT PORTD
#define IROUT_BIT PD7

//PortD Output
/****************************************/
/****************************************/
/****** Variable Definitions     ********/
/****************************************/
/****************************************/
uint8_t count=0;	//count loop timer for shoot function
char buffer[15];				//buffer for text/numbers for interval conversion, etc
volatile uint16_t ADC_Value;	//current Analog-Digital conversion value

//io init
void init_io(void)
{
	//All Ouputs on
	DDRD = 0xff;
	DDRC |= ( 1 << PC1);
}

void ADC_INIT(void)
{
					ADCSRA |= (1 << ADPS2) | (1 << ADPS0); // Set ADC prescaler to 32 - 125kHz sample rate @ 4MHz

					ADMUX |= (1 << REFS0); // Set ADC reference to AVCC

					// No MUX values needed to be changed to use ADC0

					ADCSRA |= (1 << ADEN);  // Enable ADC
	
					ADCSRA |= (1 << ADIE);  // Enable ADC Interrupt
					sei();   // Enable Global Interrupts
}

void ADC_DEINIT(void)
{
					ADCSRA |= ~(1 << ADEN);  // Disable ADC
	
					ADCSRA |= ~(1 << ADIE);  // Disable ADC Interrupt
					cli();   // Disable Global Interrupts
}

void shoot(void)
{
		for(count=0; count <=16; count++)
		{
		OUTPUT_PORT ^= (1 << IROUT_BIT); //turn on
		Delay_us(15.625);
		OUTPUT_PORT ^= (1 << IROUT_BIT); //turn off
		Delay_us(15.625);
		}
		
		Delay_us(7300);
		
		for(count=0; count <=16; count++)
		{
		OUTPUT_PORT ^= (1 << IROUT_BIT); //turn on
		Delay_us(15.625);
		OUTPUT_PORT ^= (1 << IROUT_BIT); //turn off
		Delay_us(15.625);
		}
}

int main(void)
{
	init_io();
	ADC_INIT();
	OUTPUT_PORT &= ~(1 << IROUT_BIT);
	lcd_init(LCD_DISP_ON);
	lcd_clrscr();
	lcd_puts("Current Val: \n");
	ADCSRA |= (1 << ADSC);  // Start A2D Conversions	
	while(1)
	{
		lcd_gotoxy(12,0);
		//format the string to show leading zeroes, so it looks like: Current Val: 0000 on the screen (because we don't clear the screen)
		sprintf(buffer,"%04d",ADC_Value);
		lcd_puts(buffer);
		Delay_ms(50);
	}
	ADC_DEINIT();
	return 1;
}

ISR(ADC_vect)
{
   ADC_Value = ADC;
   ADCSRA |= (1 << ADSC);  // Start A2D Conversions
   
}